;
; Virtual Disk Drive Project - June 13, 2002 - EJR (at work)
;
;;; 
;;; Here is where the hardware lines are initialized appropriately
;;;

;;;
;;; This routine exports the following symbols
;;; 
   global HardwareSetup		; set up that hardware!
	
#include "vd.h"
	
PROG1 CODE

;;;*******************************************************************
;;; NAME:	HardwareSetup()
;;;
;;; DESCR:	Set-up the in/out lines appropriately.
;;;		Does other hardwarish stuff probably in the future.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	BIG NOTE - may need to set the serial i/o pins to in
;;;		and out appropriately.  The doc says both must be "set"
;;;		which is the PO (default) values.  I'm thinking that
;;;		the receive must be set, and transmit clear.  We'll
;;;		find out pretty quickly if this is the case.
;;;*******************************************************************
HardwareSetup:

	BankSelect	0

;;; 
;;; clear all of the output latches for all of the ports
;;; 
	clrf	CONTROLS_PORT
;;;	clrf	MEMBLOCKHI_PORT	     ; DUP of CONTROLS_PORT (not needed)
	clrf	MEMBLOCKLO_PORT
	clrf	DATA_PORT
	clrf	CONTROLS2_PORT
	clrf	MEM_CONTROL_PORT

	BankSelect	1

	;; CONTROLS_PORT lines
	
	bsf	WRITE_GATE_CONF	; set as input
	bsf	HEAD_DIR_CONF	; set as input
	bsf	HEAD_MOVE_CONF	; set as input
	bsf	WDATA_CONF	; set as input

	;; MEMBLOCKHI_PORT lines
	
	bcf	MEMBLOCKHI_16_CONF	; set as output
	bcf	MEMBLOCKHI_17_CONF	; set as output

	;; MEMBLOCKLO_PORT lines

	clrf	MEMBLOCKLO_CONF		; set as output

	;; DATA_PORT lines (are wiggled continuously anyway)

	movlw	0xff
	movwf	DATA_CONF		; set initially as input (read)

	;; CONTROLS2_PORT lines
	;; NOTE - the  INDEX, and TRACK0 are controlled
	;;    by OutputOn and OutputOff during run...they are
	;;    set to input here (though they are really output
	;;    signals) to prevent spikes during "boot."

	bcf	RDATA_CONF		; set as output
	bcf	INDEX_HOLE_CONF		; set as output
	bsf	DSELECT_0_CONF		; set as input
	bsf	DSELECT_1_CONF		; set as input
	bcf	TRACK0_CONF		; set as output
	bcf	WPROTECT_CONF		; set as output

	;; MEM_CONTROL_PORT lines

	bcf	MEMINC_CONF		; set as output
	bcf	_MEMOE_CONF		; set as output
	bcf	_MEMWR_CONF		; set as output

	;; slight tweek for the PORTE - turns lines into digital
	;;   they are set analog input upon powerup

	movlw	0x07			; lower three bits to 1
	movwf	ADCON1			; working in bank 1

	BankSelect	0

	;; Put external memory in a known state

	bsf	_MEMOE			; initial state = memory data off
	bsf	_MEMWR			; write line off (high)
	bcf	MEMINC			; sits in the low state normally
					; (it used to stay high normally)

	;; ensure control lines are where they should be

	Lower	RDATA
	Lower	INDEX_HOLE
	Lower	TRACK0
	Lower	WPROTECT
	
	return

	
	END
